#include "../generator.h"
#include "../bdtypes.h"
#include "../bdfunc.h"
#include "../bdglobal.h"
#include "../scorpion.h"

static DWORD dwId[] = {homer040, homer041, homer042, homer043, homer044, homer045};
#define NB_HOMERS (sizeof(dwId)/sizeof(DWORD))
static Obj3d Homer[NB_HOMERS];
static float Matrix[16], Matrix2[16], Matrix3[16];
static float Gouraud[16], Gouraud2[16];

static float *sow, *tow;
static DWORD *A, *B, *C;

static float Sow1[] = {0,0,0,0,0,0};
static float Tow1[] = {0,30,60,90,120,150};
static float Sow2[] = {150,150,150,150,150,150};
static float Tow2[] = {0,30,60,90,120,150};
static float Sow3[] = {150,150,150,150,150,150};
static float Tow3[] = {30,60,90,120,150,180};
static float Sow4[] = {0,0,0,0,0,0};
static float Tow4[] = {30,60,90,120,150,180};

#define FOND_Z 1.f
static GrVertex Text1 = {0.f,0.f,FOND_Z,  255,128,128,   0,128.f,1.f/FOND_Z,{0,0, 1.f/FOND_Z}};
static GrVertex Text2 = {640.f,0,FOND_Z,   128,255,128,   0,128.f,1.f/FOND_Z,{256.f/FOND_Z,0,1.f/300.f}};
static GrVertex Text3 = {640.,480.,FOND_Z,   64,64,192,   0,128.f,1.f/FOND_Z,{256.f/FOND_Z,256.f/FOND_Z,1.f/FOND_Z}};
static GrVertex Text4 = {0,480.,FOND_Z,   64,64,192,   0,128.f,1.f/FOND_Z,{0,256.f/FOND_Z,1.f/FOND_Z}};

//

static FbVertex pVertexIn[] =
{
	{-50,25,-150,  0.f,0,0,   0,0,0.f, {0.f, 0.f, 0.f}},
	{50,25,-150,  0.f,0,0,   0,0,0.f, {256.f, 0.f, 0.f}},
	{50,25,500,  0.f,0,0,   0,0,0.f, {256.f, 1024.f, 0.f}},
	{-50,25,500,  0.f,0,0,   0,0,0.f, {0.f, 1024.f, 0.f}},

	{-50,-25,-150,  0.f,0,0,   0,0,0.f, {256.f, 0.f, 0.f}},
	{50,-25,-150,  0.f,0,0,   0,0,0.f, {0.f, 0.f, 0.f}},
	{50,-25,500,  0.f,0,0,   0,0,0.f, {0.f, 1024.f, 0.f}},
	{-50,-25,500,  0.f,0,0,   0,0,0.f, {256.f, 1024.f, 0.f}},

	{-50,-25,-150,  0.f,0,0,   0,0,0.f, {0.f, 0.f, 0.f}},
	{-50,25,-150,  0.f,0,0,   0,0,0.f, {256.f, 0.f, 0.f}},
	{-50,25,500,  0.f,0,0,   0,0,0.f, {256.f, 1024.f, 0.f}},
	{-50,-25,500,  0.f,0,0,   0,0,0.f, {0.f, 1024.f, 0.f}},

	{50,-25,-150,  0.f,0,0,   0,0,0.f, {0.f, 0.f, 0.f}},
	{50,25,-150,  0.f,0,0,   0,0,0.f, {256.f, 0.f, 0.f}},
	{50,25,500,  0.f,0,0,   0,0,0.f, {256.f, 1024.f, 0.f}},
	{50,-25,500,  0.f,0,0,   0,0,0.f, {0.f, 1024.f, 0.f}},

	{-50,-25,500,  0.f,0,0,   0,0,0.f, {0.f, 0.f, 0.f}},
	{50,-25,500,  0.f,0,0,   0,0,0.f, {256.f, 0.f, 0.f}},
	{50,25,500,  0.f,0,0,   0,0,0.f, {256.f, 1024.f, 0.f}},
	{-50,25,500,  0.f,0,0,   0,0,0.f, {0.f, 1024.f, 0.f}},
};
static GrVertex pVertexOut[sizeof(pVertexIn)/sizeof(FbVertex)];

static Face pFace[] =
{
	{0,1,2},
	{2,3,0},
	{4,5,6},
	{6,7,4},
	{8,9,10},
	{10,11,8},
	{12,13,14},
	{14,15,12},

	{16,17,18},
	{18,19,16},
};

static Obj3d Corridor = 
{
	pVertexIn,
	pVertexOut,
	sizeof(pVertexIn)/sizeof(FbVertex), // Nb Vertexes
	pFace,
	sizeof(pFace)/sizeof(Face)
};

//

static FbVertex pVertexIn2[] =
{
	{-50,15,-150,  0.f,0,0,   0,0,0.f, {0.f, 0.f, 0.f}},
	{50,15,-150,  0.f,0,0,   0,0,0.f, {128.f, 0.f, 0.f}},
	{50,15,500,  0.f,0,0,   0,0,0.f, {128.f, 1024.f, 0.f}},
	{-50,15,500,  0.f,0,0,   0,0,0.f, {0.f, 1024.f, 0.f}},
};
static GrVertex pVertexOut2[sizeof(pVertexIn2)/sizeof(FbVertex)];

static Face pFace2[] =
{
	{0,1,2},
	{2,3,0},
};

static Obj3d Water = 
{
	pVertexIn2,
	pVertexOut2,
	sizeof(pVertexIn2)/sizeof(FbVertex), // Nb Vertexes
	pFace2,
	sizeof(pFace2)/sizeof(Face)
};


void LInit_Homer()
{
	DWORD Cpt1, Cpt2;
	FILE *file;
	DWORD dwNbVertices, dwNbFaces;
	DWORD dwDummy;

	for(Cpt1=0;Cpt1<NB_HOMERS;Cpt1++)
	{
		LoadObject(&Homer[Cpt1], dwId[Cpt1], homerface);
		ComputeGouraud(&Homer[Cpt1]);
	}
	PrepareTextureFromArray(g_PicHomer, 256, 256, &g_TextureHomer);
	PrepareTextureFromArray(g_PicTunn3d, 256, 256, &g_TextureTunn3d);
	PrepareTextureFromArray(g_PicGlyphs, 256, 256, &g_TextureGlyphs);
	PrepareTextureFromArray(g_PicMonster, 256, 256, &g_TextureMonster);
	
	file = fopen(PackageName, "rb");
	SeekToSubfile(file, homermap, &dwDummy);

	fread(&dwNbVertices, 4, 1, file);
	fread(&dwNbFaces, 4, 1, file);

	sow = (float*)malloc(dwNbVertices*sizeof(float));
	tow = (float*)malloc(dwNbVertices*sizeof(float));
	A = (DWORD*)malloc(dwNbFaces*sizeof(DWORD));
	B = (DWORD*)malloc(dwNbFaces*sizeof(DWORD));
	C = (DWORD*)malloc(dwNbFaces*sizeof(DWORD));

	for(Cpt1=0;Cpt1<dwNbVertices;Cpt1++)
	{
		fread(sow+Cpt1, 4, 1, file);
		fread(tow+Cpt1, 4, 1, file);
	}

	for(Cpt1=0;Cpt1<dwNbFaces;Cpt1++)
	{
		fread(A+Cpt1, 4, 1, file);
		fread(B+Cpt1, 4, 1, file);
		fread(C+Cpt1, 4, 1, file);
	}

	for(Cpt2=0;Cpt2<NB_HOMERS;Cpt2++)
	for(Cpt1=0;Cpt1<dwNbFaces;Cpt1++)
	{
		Homer[Cpt2].pFace[Cpt1].SowA = sow[C[Cpt1]];
		Homer[Cpt2].pFace[Cpt1].TowA = tow[C[Cpt1]];
		Homer[Cpt2].pFace[Cpt1].SowB = sow[B[Cpt1]];
		Homer[Cpt2].pFace[Cpt1].TowB = tow[B[Cpt1]];
		Homer[Cpt2].pFace[Cpt1].SowC = sow[A[Cpt1]];
		Homer[Cpt2].pFace[Cpt1].TowC = tow[A[Cpt1]];
	}

	fclose(file);
}

void QInit_Homer()
{
	grDepthBufferMode(GR_DEPTHBUFFER_WBUFFER);
	grDepthBufferFunction(GR_CMP_LESS);
	grAlphaCombine(GR_COMBINE_FUNCTION_LOCAL, GR_COMBINE_FACTOR_ONE,
					GR_COMBINE_FACTOR_NONE, GR_COMBINE_OTHER_NONE, FXFALSE);
	grAlphaBlendFunction(GR_BLEND_ONE, GR_BLEND_ZERO, GR_BLEND_ZERO, GR_BLEND_ZERO);

	grAlphaTestFunction(GR_CMP_ALWAYS);
	grChromakeyMode(GR_CHROMAKEY_DISABLE);
	grCullMode(GR_CULL_DISABLE);
	//grFogMode(GR_FOG_DISABLE);
	grFogMode(GR_FOG_WITH_TABLE);
	grFogColorValue(0x33aa33);
	grFogTable(g_FogHomer);

	grConstantColorValue(0xffffffff);

	DownloadTexture(&g_TextureTunn3d);
	DownloadTexture(&g_TextureGlyphs);
	DownloadTexture(&g_TextureMonster);
	DownloadTexture(&g_TextureHomer);
}

void DrawSomeText(DWORD Id, float x, float y, DWORD dwMore)
{
	float fSizeX, fSizeY;

	fSizeX = 20.f*SinTable[(dwMore+g_demostate.TickInEffect*8)&8191];
	fSizeY = 20.f*CosTable[(dwMore+g_demostate.TickInEffect*8)&8191];
	Text1.x = x-fSizeX; Text1.y = y-fSizeY; Text1.tmuvtx[0].sow = Sow1[Id]; Text1.tmuvtx[0].tow = Tow1[Id];
	Text2.x = x+150+fSizeX; Text2.y = y-fSizeY; Text2.tmuvtx[0].sow = Sow2[Id]; Text2.tmuvtx[0].tow = Tow2[Id];
	Text3.x = x+150+fSizeX; Text3.y = y+60+fSizeY; Text3.tmuvtx[0].sow = Sow3[Id]; Text3.tmuvtx[0].tow = Tow3[Id];
	Text4.x = x-fSizeX; Text4.y = y+60+fSizeY; Text4.tmuvtx[0].sow = Sow4[Id]; Text4.tmuvtx[0].tow = Tow4[Id];
	guDrawTriangleWithClip(&Text1, &Text2, &Text3);
	guDrawTriangleWithClip(&Text3, &Text4, &Text1);
}

void Effect_Homer()
{
	float TransX, TransZ;
	static float fLastTick = 0;
	float fProgress;
	DWORD Cpt1;
	static DWORD dwFirst23 = 0;
	float fCommonSin;
	DWORD dwRedIsDead;

	if ((g_demostate.midas_status.position==23)&&(dwFirst23==0))
		dwFirst23 = g_demostate.TickInEffect;
	fCommonSin = 1.2f+0.5f*SinTable[((g_demostate.TickInEffect-dwFirst23)*8*5000/8192)&8191];

	grAlphaBlendFunction(GR_BLEND_ONE, GR_BLEND_ZERO, GR_BLEND_ZERO, GR_BLEND_ZERO);
	if (g_demostate.midas_status.position<23)
	{
		grColorCombine(GR_COMBINE_FUNCTION_SCALE_OTHER,
						GR_COMBINE_FACTOR_ONE,
						GR_COMBINE_LOCAL_ITERATED, GR_COMBINE_OTHER_TEXTURE, FXFALSE);
	}
	else
	{
		grColorCombine(GR_COMBINE_FUNCTION_SCALE_OTHER,
						GR_COMBINE_FACTOR_LOCAL,
						GR_COMBINE_LOCAL_CONSTANT, GR_COMBINE_OTHER_TEXTURE, FXFALSE);
		//dwRedIsDead = (((g_demostate.TickInPattern%(5200/4))*256/1300)&255)<<16;
		//dwRedIsDead = SinTable[(g_demostate.TickInEffect*8192*4/5000)&8191]*128;
		dwRedIsDead = 128.f*SinTable[((g_demostate.TickInEffect-dwFirst23)*8*5000/8192)&8191];
		dwRedIsDead = CLIP_DW(dwRedIsDead);
		dwRedIsDead = dwRedIsDead|(dwRedIsDead<<8)|(dwRedIsDead<<16);
		grConstantColorValue(dwRedIsDead);
	}
	SelectTexture(g_TextureHomer);
	BeIdentityMatrix(Matrix);
	BeIdentityMatrix(Gouraud);
	RotateXMatrix(Matrix2, Matrix, 2048);
	RotateYMatrix(Matrix, Matrix2, 2048);
	RotateZMatrix(Matrix2, Matrix, 256*CosTable[(g_demostate.TickInEffect*2)&8191]);
	RotateYMatrix(Gouraud2, Gouraud, -2048);
	RotateXMatrix(Gouraud, Gouraud2, -2048);
	TransX = 40.f*CosTable[g_demostate.TickInEffect&8191];
	TransZ = 25.f*CosTable[(g_demostate.TickInEffect)&8191];
	TranslateMatrix(Matrix2, TransX, 0, 70+TransZ);
	// ah ah
	if (g_demostate.midas_status.position>=23)
		ScaleMatrix(Matrix2, 1, 1, 
		fCommonSin);
	DrawWithMatrix(&Homer[(g_demostate.TickInEffect/64)%NB_HOMERS], Matrix2, FALSE, Gouraud, 1);

	BeIdentityMatrix(Matrix);
	RotateZMatrix(Matrix2, Matrix, 256*CosTable[(g_demostate.TickInEffect*2)&8191]);
	TranslateMatrix(Matrix2, TransX, 0, 70+TransZ);
	if (g_demostate.midas_status.position<23)
	{
		grColorCombine(GR_COMBINE_FUNCTION_SCALE_OTHER,
						GR_COMBINE_FACTOR_ONE,
						GR_COMBINE_LOCAL_ITERATED, GR_COMBINE_OTHER_TEXTURE, FXFALSE);
	}
	else
	{
		grColorCombine(GR_COMBINE_FUNCTION_SCALE_OTHER,
						GR_COMBINE_FACTOR_LOCAL,
						GR_COMBINE_LOCAL_CONSTANT, GR_COMBINE_OTHER_TEXTURE, FXFALSE);
		grConstantColorValue(dwRedIsDead);
	}
	SelectTexture(g_TextureTunn3d);
	// ah ah
	if (g_demostate.midas_status.position>=23)
		ScaleMatrix(Matrix2, 1, 1,
		fCommonSin);
	DrawWithMatrix(&Corridor, Matrix2, FALSE, Gouraud, 0);

	grConstantColorValue((128<<24)|(128<<16)|(128<<8)|128);
	grAlphaCombine(GR_COMBINE_FUNCTION_BLEND_OTHER, GR_COMBINE_FACTOR_ONE,
					GR_COMBINE_LOCAL_NONE, GR_COMBINE_OTHER_CONSTANT, 
					FXFALSE);
	grAlphaBlendFunction(GR_BLEND_SRC_ALPHA, GR_BLEND_ONE_MINUS_SRC_ALPHA, 
		GR_BLEND_ZERO, GR_BLEND_ZERO);
	BeIdentityMatrix(Matrix3);
	TranslateMatrix(Matrix3, TransX, 0, 70+TransZ);
	SelectTexture(g_TextureGlyphs);
	// ah ah
	if (g_demostate.midas_status.position>=23)
		ScaleMatrix(Matrix3, 1, 1,
		fCommonSin);
	DrawWithMatrix(&Water, Matrix3, FALSE, Gouraud, 0);

	fProgress = -(g_demostate.TickInEffect - fLastTick)/16;
	fLastTick = g_demostate.TickInEffect;
	for(Cpt1=0;Cpt1<sizeof(pVertexIn)/sizeof(FbVertex);Cpt1++)
	{
		pVertexIn[Cpt1].tmuvtx[0].tow += fProgress;
	}
	for(Cpt1=0;Cpt1<sizeof(pVertexIn2)/sizeof(FbVertex);Cpt1++)
	{
		pVertexIn2[Cpt1].tmuvtx[0].tow -= fProgress*4;
	}

	if ((g_demostate.midas_status.position<23)&&(g_demostate.TickInEffect>5000/4))
	{
		grAlphaCombine(GR_COMBINE_FUNCTION_LOCAL, GR_COMBINE_FACTOR_ONE,
						GR_COMBINE_FACTOR_NONE, GR_COMBINE_OTHER_NONE, FXFALSE);
		grAlphaBlendFunction(GR_BLEND_ONE_MINUS_DST_COLOR, GR_BLEND_ONE_MINUS_SRC_COLOR, 
			GR_BLEND_ZERO, GR_BLEND_ZERO);
		if (g_demostate.TickInEffect<10000-1024)
			grColorCombine(GR_COMBINE_FUNCTION_SCALE_OTHER,
							GR_COMBINE_FACTOR_ONE,
							GR_COMBINE_LOCAL_ITERATED, GR_COMBINE_OTHER_TEXTURE, FXFALSE);
		else
		{
			DWORD dwTmp;

			grColorCombine(GR_COMBINE_FUNCTION_SCALE_OTHER,
							GR_COMBINE_FACTOR_LOCAL,
							GR_COMBINE_LOCAL_CONSTANT, GR_COMBINE_OTHER_TEXTURE, FXFALSE);
			dwTmp = (10000-g_demostate.TickInEffect)*256/1024;
			dwTmp = CLIP_DW(dwTmp);
			grConstantColorValue(dwTmp|(dwTmp<<8)|(dwTmp<<16));
		}
		SelectTexture(g_TextureMonster);
		grDepthBufferFunction(GR_CMP_ALWAYS);
		DrawSomeText(0, 200,50, 0);
		if (g_demostate.TickInEffect>5000/4*2)
		{
			DrawSomeText(1, 350,75, 2500);
			if (g_demostate.TickInEffect>5000/4*3)
			{
				DrawSomeText(2, 150,125, 5000);
				if (g_demostate.TickInEffect>5000/4*4)
				{
					DrawSomeText(3, 300,185, 7500);
					if (g_demostate.TickInEffect>5000/4*5)
					{
						DrawSomeText(4, 175,250, 10000);
						if (g_demostate.TickInEffect>5000/4*6)
						{
							DrawSomeText(5, 400,300, 12500);
						}
					}
				}
			}
		}
		grDepthBufferFunction(GR_CMP_LESS);
	}

}

void ByeBye_Homer()
{
	FreeTexture(&g_TextureHomer);
	FreeTexture(&g_TextureMonster);
	FreeTexture(&g_TextureGlyphs);
	FreeTexture(&g_TextureTunn3d);
}